local t = Def.ActorFrame {};

local playMode = GAMESTATE:GetPlayMode()

local sStage = ""
sStage = GAMESTATE:GetCurrentStage()

if playMode ~= 'PlayMode_Regular' and playMode ~= 'PlayMode_Rave' and playMode ~= 'PlayMode_Battle' then
  sStage = playMode;
end;

if not (GAMESTATE:IsCourseMode() or GAMESTATE:IsExtraStage() or GAMESTATE:IsExtraStage2()) then
        local tRemap = {
                Stage_Event             = 0,
                Stage_1st               = 1,
                Stage_2nd               = 2,
                Stage_3rd               = 3,
                Stage_4th               = 4,
                Stage_5th               = 5,
                Stage_6th               = 6,
                Stage_Final               = 7,
                Stage_Extra1               = 8,
                Stage_Extra2              = 9,
        };

        local nSongCount = tRemap[sStage] + (GAMESTATE:GetCurrentSong():GetStageCost()-1);

        if nSongCount >= PREFSMAN:GetPreference("SongsPerPlay") then
        sStage = "Stage_Final";
        else
                sStage = sStage;
        end;
end;

	t[#t+1] = Def.Quad {
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;diffuse,color("#FFFFFF");zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;);
		OnCommand=function(self)
			self:diffusealpha(0):linear(0.3):diffusealpha(1):sleep(2);
		end;		
	};
			
	if not GAMESTATE:IsCourseMode() then
		t[#t+1] = Def.Sprite {
			InitCommand=cmd(Center);
			BeginCommand=cmd(LoadFromCurrentSongBackground);
			OnCommand=function(self)
			self:scale_or_crop_background()
			self:diffusealpha(0):sleep(2.2):diffusealpha(0.2):sleep(2);
			end;
		};
	end
	

	t[#t+1] = Def.ActorFrame {
	OnCommand=cmd(diffusealpha,0;sleep,2.2;diffusealpha,1;sleep,2;);

		Def.ActorFrame {
			InitCommand=cmd(x,SCREEN_CENTER_X+150;y,SCREEN_CENTER_Y;rotationz,-16;zoom,0.8;);
			OnCommand=cmd(diffusealpha,0;addy,13;sleep,1.8;linear,0.4;addy,-13;diffusealpha,1;);
			LoadActor(THEME:GetPathG("_jacket", "shell")) .. {
				InitCommand=cmd(zoom,0.55);
			};
			Def.Sprite {
				name="SongJacket";
				OnCommand=cmd(playcommand,"Set");
				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
				SetCommand=function(self)
				local target = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse() or GAMESTATE:GetCurrentSong()
							if target then
								if GAMESTATE:IsCourseMode() == false then
									if target:HasJacket() == true then
										self:Load(target:GetJacketPath())
										self:scaletoclipped(246,246)
									elseif target:HasBackground() == true then
										self:Load(target:GetBackgroundPath())
										self:scaletoclipped(246,246)
									elseif target:HasBanner() == true then
										self:Load(target:GetBannerPath())
										self:scaletoclipped(256,80)
									elseif target:HasBanner() == false then
										self:Load(THEME:GetPathG("Common fallback", "jacket"))
										self:scaletoclipped(246,246)
									end
								else
									if target:HasBanner() == true then
										self:Load(target:GetBannerPath())
										self:scaletoclipped(256,80)
									elseif target:HasBanner() == false then
										self:Load(THEME:GetPathG("Common fallback", "jacket"))
										self:scaletoclipped(246,246)
									end
								end;
							else
								self:Load(THEME:GetPathG("Common fallback", "jacket"))
							end
					end;
			};
		};
	--Credits
		Def.ActorFrame {
			InitCommand=cmd(x,SCREEN_CENTER_X-220;y,SCREEN_CENTER_Y+76);
			LoadFont("Common Normal") .. {
			  Text=GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse():GetDisplayFullTitle() or GAMESTATE:GetCurrentSong():GetDisplayFullTitle();
			  InitCommand=cmd(horizalign,left;diffuse,color("#000000");strokecolor,color("#FFFFFF");maxwidth,480);
			  OnCommand=cmd(zoom,1);
			};
			LoadFont("Common Normal") .. {
			  Text=GAMESTATE:IsCourseMode() and ToEnumShortString( GAMESTATE:GetCurrentCourse():GetCourseType() ) or GAMESTATE:GetCurrentSong():GetDisplayArtist();
			  InitCommand=cmd(horizalign,left;diffuse,color("#000000");strokecolor,color("#FFFFFF");maxwidth,480);
			  OnCommand=cmd(zoom,0.8;addy,26;);
			};
			LoadActor( THEME:GetPathG("ScreenStageInformation", "Stage " .. ToEnumShortString(sStage) ) ) .. {
			  InitCommand=cmd(horizalign,right;addx,250);
			  OnCommand=cmd(zoom,0.6;addy,-45;);
			};		
		};
	};


t[#t+1] = Def.ActorFrame {
	OnCommand=cmd(sleep,1.3;diffusealpha,0);
	LoadActor("_toptri") .. {
		InitCommand=cmd(horizalign,right;x,SCREEN_LEFT;y,SCREEN_CENTER_Y;);
		OnCommand=cmd(accelerate,0.2;addx,SCREEN_WIDTH-60;);
	};
	LoadActor("_bottri") .. {
		InitCommand=cmd(horizalign,left;x,SCREEN_RIGHT;y,SCREEN_CENTER_Y;);
		OnCommand=cmd(accelerate,0.2;addx,-SCREEN_WIDTH+60;);
	};
};

t[#t+1] = Def.ActorFrame {
	LoadActor("_aring") .. {
		InitCommand=cmd(Center;zoom,0);
		OnCommand=cmd(sleep,0.2;decelerate,1;zoom,1.3;sleep,0.3;diffusealpha,0;);
	};
	
	LoadActor("_cring") .. {
		InitCommand=cmd(Center;zoom,0);
		OnCommand=cmd(sleep,0.2;sleep,0.4;decelerate,1.0;zoom,1.3;sleep,0.3;diffusealpha,0;);
	};
	LoadActor("_bring") .. {
		InitCommand=cmd(Center;zoom,0);
		OnCommand=cmd(sleep,0.2;sleep,1.1;decelerate,1.;zoom,1.3;smooth,0.3;diffusealpha,0;sleep,1.3;);
	};
};

return t;